--[[
eval is:

[ok] character
[**] difficulty icon
[**] difficulty meter

so why is it tripping up
]]

local t = Def.ActorFrame{};

-- enabling this will create a loop that is hard to get out from right now.
t[#t+1] = Def.Actor{
	Name="HackyHack";
	BeginCommand=function(self)
		if GAMESTATE:IsCourseMode() then
			-- figure out if we need to apply fail mods
			local pm = GAMESTATE:GetPlayMode();
			local songOptions;
			if pm == 'PlayMode_Endless' then
				-- we need to fail on endless or else it's pointless.
				songOptions = "FailAtEnd";
			else
				-- well, Nonstop really is the only other course mode available...
				songOptions = "FailImmediate";
			end;

			GAMESTATE:SetSongOptions("ModsLevel_Stage", songOptions);
			MESSAGEMAN:Broadcast("SongOptionsChanged");
			SCREENMAN:SetNewScreen("ScreenGameplay");
		end
	end;
};

--[[  characters ]]
local Characters = Def.ActorFrame{};

Characters[#Characters+1] = LoadActor( THEME:GetPathG("","_common/boy") )..{
	InitCommand=cmd(x,SCREEN_CENTER_X+112;y,SCREEN_CENTER_Y-20;diffusealpha,0);
	BeginCommand=function(self)
		if not GAMESTATE:IsHumanPlayer(PLAYER_1) then self:visible(false);
		else self:visible(true);
		end;
	end;
	OnCommand=cmd(sleep,0.2;zoom,1.2;decelerate,0.4;diffusealpha,1;zoom,1;);
};

Characters[#Characters+1] = LoadActor( THEME:GetPathG("","_common/girl") )..{
	InitCommand=cmd(x,SCREEN_CENTER_X+270;y,SCREEN_CENTER_Y+20;diffusealpha,0);
	BeginCommand=function(self)
		if not GAMESTATE:IsHumanPlayer(PLAYER_2) then self:visible(false);
		else self:visible(true);
		end;
	end;
	OnCommand=cmd(sleep,0.2;zoom,1.2;decelerate,0.4;diffusealpha,1;zoom,1;);
};

t[#t+1] = Characters;
--[[ /characters ]]

--[[  difficulty icon ]]
local DifficultyIcons = Def.ActorFrame{};

for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
	local xLoc = (pn == PLAYER_1) and SCREEN_CENTER_X+112 or SCREEN_CENTER_X+310;
	local yLoc = (pn == PLAYER_1) and SCREEN_CENTER_Y+90 or SCREEN_CENTER_Y+130;
	
	DifficultyIcons[#DifficultyIcons+1] = LoadActor("DifficultyIcon", pn)..{
		InitCommand=cmd(x,xLoc;y,yLoc;zoom,0;diffusealpha,0);
		BeginCommand=function(self)
			if getenv("NewPara") then self:visible(false);
			else self:visible(true);
			end;
		end;
		OnCommand=cmd(sleep,0.2;zoom,1.2;decelerate,0.4;diffusealpha,1;zoom,1;);
	};
end;

t[#t+1] = DifficultyIcons;
--[[ /difficulty icon ]]

--[[  difficulty meter ]]
local DifficultyMeters = Def.ActorFrame{};

for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
	local xLoc = (pn == PLAYER_1) and SCREEN_CENTER_X+48 or SCREEN_CENTER_X+244;
	local yLoc = (pn == PLAYER_1) and SCREEN_CENTER_Y+105 or SCREEN_CENTER_Y+140;
	
	DifficultyMeters[#DifficultyMeters+1] = LoadActor("DifficultyMeterDeluxe", pn)..{
		InitCommand=cmd(x,xLoc;y,yLoc;diffusealpha,0;);
		OnCommand=cmd(sleep,0.4;zoom,1.2;decelerate,0.4;diffusealpha,1;zoom,1;);
	};
end;

t[#t+1] = DifficultyMeters;
--[[ /difficulty meter ]]

return t;